# FedSR: Frequency-Aware Enhancement for Diffusion-based Image  Super-Resolution


We propose a training-free framework FedSR, which encapsulates two key components. This is the source code framework for any diffusion-based framework. Note that our method should be plugged into a existed diffusion-based ISR model.



#### For test SR on 128 --> 512

##### 1. Download the models from StableSR

(1) the fine-tuned Diffusion model (SD2.1) https://huggingface.co/Iceclear/StableSR/resolve/main/stablesr_000117.ckpt

(2) the autoencoder model https://huggingface.co/Iceclear/StableSR/resolve/main/vqgan_cfw_00011.ckpt

##### 2. Running test scripts

```
python scripts/sr_val_ddpm_text_T_vqganfin_old.py --config configs/stableSRNew/v2-finetune_text_T_512.yaml --ckpt CKPT_PATH --vqgan_ckpt VQGANCKPT_PATH --init-img INPUT_PATH --outdir OUT_DIR --ddpm_steps 200 --dec_w 0.5 --colorfix_type adain
```



#### Notes

This example code is based on [LDM](https://github.com/Stability-AI/stablediffusion) and [BasicSR](https://github.com/XPixelGroup/BasicSR). And some codes are brought from [StableSR](https://github.com/IceClear/StableSR) and [FreeU](https://github.com/ChenyangSi/FreeU).

