# Hybrid Image Transformation 

This is Pytorch code for our paper "Practical No-box Adversarial Attacks with Training-free Hybrid Image Transformation". In this paper, we move a step forward and show the existence of a **training-free** adversarial perturbation under the no-box threat model, which can be successfully used to attack different DNNs in real-time. Extensive experiments on the ImageNet dataset demonstrate the effectiveness of the proposed no-box method. It attacks ten well-known models with a success rate of **98.13%** on average, which outperforms state-of-the-art no-box attacks by **29.39%**. Furthermore, our method is even competitive to mainstream transfer-based black-box attacks.

**We will make our repo public after this paper is accepted.**
 


## Implementation

- Pytorch 1.5.1, Python 3.7

- Put the images into "input/" whose structure is 

  ```
  UIP
  |───input
  |   |───n01440764
  |   |───n01443537
  |   |───n01484850
  |   |───n01491361
  |   |───n01494475
  .....
  |   |───n15075141
  ```

  where each folder represents a category and `torch.utils.data.DataLoader()` can automatically get their corresponding labels

- Run the below code to generate adversarial examples

  ```python
  python HIT.py
  ```

  Then the output adversarial images are in "output/".

- If you want to check the performance, please run the below code to evaluate the attack success rate

  ```python
  python attack_eval.py
  ```





