def llm_response(llm_type, prompt, stop_sequences=[''], check_time=True):
    if llm_type == "gemini":
        from .llm_utils.gemini import gemini_response as target_model_response
    elif llm_type == "openai":
        from .llm_utils.openai_utils import chatgpt_response as target_model_response
    elif llm_type == "llama":
        from .llm_utils.llama import llama_response as target_model_response
    else:
        raise ValueError(f"Unsupported LLM type: {llm_type}")

    return target_model_response(prompt, stop_sequences, check_time)
