import time
from openai import OpenAI


openai_client = OpenAI(api_key="API-KEY")
deepseek_client = OpenAI(
    api_key="API-KEY",
    base_url="https://api.deepseek.com/v1"
)

def chatgpt_response(
    prompt: str,
    temperature: float = 0.0,
    stop_sequences: list[str] = None,
    check_time: bool = True,
    source: str = "openai"
) -> str | None:
    model = None
    client = openai_client if source == "openai" else deepseek_client
    model = model or ("gpt-4o-mini" if source == "openai" else "deepseek-reasoner")
    stop_sequences = stop_sequences or ['']

    start_time = time.time()
    try:
        response = client.chat.completions.create(
            model=model,
            messages=[{"role": "user", "content": prompt}],
        )
        if check_time:
            elapsed = time.time() - start_time
            print(f"[{source.upper()}] Response time: {elapsed:.2f}s")
        return response.choices[0].message.content

    except Exception as e:
        print(f"{source.upper()} API Error:", str(e))
        return None