import os
import glob
import subprocess

def solve_pddl(domain_pddl, problem_pddl):

    # Configure paths as needed
    fast_downward_path = "Input_Your_Path"
    debug_dir = "Input_Your_Path"
    os.makedirs(debug_dir, exist_ok=True)

    # Prepare file paths
    domain_file = os.path.join(debug_dir, "domain_temp.pddl")
    problem_file = os.path.join(debug_dir, "problem_temp.pddl")
    plan_file = os.path.join(debug_dir, "sas_plan")

    # Remove old plan files
    old_plan_files = glob.glob(os.path.join(debug_dir, "sas_plan*"))
    for opf in old_plan_files:
        os.remove(opf)

    # Write domain PDDL
    with open(domain_file, 'w') as f:
        f.write(domain_pddl)

    # Write problem PDDL
    with open(problem_file, 'w') as f:
        f.write(problem_pddl)

    try:
        # Run Fast Downward
        command = (
            f"{fast_downward_path} --alias seq-sat-lama-2011 "
            f"--plan-file {plan_file} {domain_file} {problem_file}"
        )
        result = subprocess.run(
            command, shell=True,
            capture_output=True, text=True,
            timeout=40  # 40-second timeout
        )

        # Check if any plan files were generated
        plan_files = glob.glob(os.path.join(debug_dir, "sas_plan*"))
        if not plan_files:
            # No plan found, return stderr for debugging
            error_message = f"No plan found. Fast Downward output:\n{result.stderr}"
            return False, error_message

        # Read the first plan file (if multiple, adapt as needed)
        with open(plan_files[0], "r") as pf:
            plan_content = pf.read().strip()

        # If plan_content is empty for some reason, treat as no plan
        if not plan_content:
            error_message = f"Plan file generated but empty. Fast Downward output:\n{result.stderr}"
            return False, error_message

        return True, plan_content

    except subprocess.TimeoutExpired as e:
        # Planner timed out, include output captured before timeout
        error_message = f"Planner timed out after 40 seconds. Output:\n{e.output}"
        return False, error_message
    except Exception as e:
        # Any other failure, include exception details
        error_message = f"Solving failed with exception: {str(e)}"
        return False, error_message