def real_world_generate_pddl_prompt_with_skill_goals(domain_pddl: str, observation: str, instructions: str, available_skills: list, skill_code: str) -> str:
    prompt_template = """
You are an AI assistant that generates structured specifications for task execution based on provided environment details. 

Given the following input information:
- **Domain PDDL:** A formal representation of the problem domain, including objects, predicates, and actions.
- **Observation:** The current state or scenario describing the environment and its conditions.
- **Instructions:** High-level guidelines specifying what needs to be achieved.
- **Available Skills:** A set of predefined skills or actions that can be utilized to accomplish the given task.

### **Task**
1. Analyze the **Domain PDDL**, **Observation**, and **Instructions** to determine the key requirements for the specification.
2. Structure the specification in a way that explicitly describes the task execution while ensuring compatibility with the given domain and available skills.
3. Format the output in a structured manner so that it can be directly translated into executable code.
4. Please check the skill code and list of possible skills and use only those within the given skill.
5. For parameters that are ambiguous to write, you can output them as blank spaces.

### **Input**
- **Domain PDDL:** {domain_pddl}
- **Observation:** {observation}
- **Instructions:** {instructions}
- **Available Skills:** {available_skills}
- **Skill Code:** {skill_code}

### **Output Format**
Specification: {{"required_skills": ["<List of relevant skills required for execution>"], "steps": [ {{ "step": 1, "action": "<First action>", "parameters": ["<param1>", "<param2>"] }}, {{ "step": 2, "action": "<Next action>", "parameters": ["<param1>", "<param2>"] }}, ... ] }}

Ensure that the generated **Specification** follows the given constraints, correctly maps to available skills, and is logically consistent with the provided **Domain PDDL**.

### **Specification Generation**
Output should not use any code block. Please provide the structured specification as plain text.

**Example:** 
[Example Skill Code]
If you want to open the drawer and put dice1 in the bottom drawer, you can create a generated_skill_sequence() function like below.
```python
def generated_skill_sequence(self):
    self.execute_movement(self.task1["drawer_bottom_handle"], mode = 1)
    self.execute_movement(self.task1["drawer_bottom_handle"], mode = 4, distance=0.1)
    self.execute_movement(self.task1["green_dice"], mode = 1)
    self.execute_movement(self.task1["drawer_bottom_place_left"], mode = 2)
    self.execute_movement(self.task1["yellow_dice"], mode = 1)
    self.execute_movement(self.task1["drawer_bottom_place_right"], mode = 2)
    self.execute_movement(self.task1["drawer_bottom_handle"], mode = 3, distance=0.15)
    self.execute_movement(mode = 8)
```


    """

    skills_list = "\n".join(available_skills)
    prompt = prompt_template.format(
        domain_pddl=domain_pddl, 
        observation=observation, 
        instructions=instructions,
        available_skills=skills_list,
        skill_code=skill_code
    )

    return prompt

def rlbench_generate_pddl_prompt_with_skill_goals(domain_pddl: str, observation: str, instructions: str, available_skills: list, skill_code: str, plan_content: str) -> str:
    prompt_template = """
You are an AI assistant that generates structured specifications for task execution based on provided environment details. 

Given the following input information:
- **Domain PDDL:** A formal representation of the problem domain, including objects, predicates, and actions.
- **Observation:** The current state or scenario describing the environment and its conditions.
- **Instructions:** High-level guidelines specifying what needs to be achieved.
- **Available Skills:** A set of predefined skills or actions that can be utilized to accomplish the given task.

### **Task**
1. Analyze the **Domain PDDL**, **Observation**, and **Instructions** to determine the key requirements for the specification.
2. Structure the specification in a way that explicitly describes the task execution while ensuring compatibility with the given domain and available skills.
3. Format the output in a structured manner so that it can be directly translated into executable code.
4. Please check the skill code and list of possible skills and use only those within the given skill.
5. For parameters that are ambiguous to write, you can output them as blank spaces.

### **Input**
- **Domain PDDL:** {domain_pddl}
- **Observation:** {observation}
- **Instructions:** {instructions}
- **Available Skills:** {available_skills}
- **Skill Code:** {skill_code}
- **Plan Content:** {plan_content}

### **Output Format**
Specification: {{“required_skills”: [/* List only the skills provided in available_skills that are needed /], “steps”: [
/ IMPORTANT: If plan content is provided, the steps below MUST exactly mirror the skill sequence found in plan content. Do not generate a new or different sequence. Use the sequence from plan content verbatim. /
{{ “step”: 1, “action”: “<action from plan content step 1>”, “parameters”: [””, “”] }},
{{ “step”: 2, “action”: “<action from plan content step 2>”, “parameters”: [””, “”] }}
/ Additional steps can be added if the plan content includes more actions. For any ambiguous parameter, leave the value as a blank space. */
]}}

Ensure that the generated **Specification** follows the given constraints, correctly maps to available skills, and is logically consistent with the provided **Domain PDDL**.

### **Specification Generation**
Output should not use any code block. Please provide the structured specification as plain text.

**Example:** 
[Example Skill Code]
If you want to open the drawer and put dice1 in the bottom drawer, you can create a generated_skill_sequence() function like below.
```python
        positions = get_object_positions()
        
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']

        print("[Task] Picking rubbish at:", rubbish_pos)
        obs, reward, done = pick(
            env, task,
            target_pos=rubbish_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking!")
            return

        print("[Task] Placing rubbish in bin at:", bin_pos)
        obs, reward, done = place(
            env, task,
            target_pos=bin_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False).")
```


    """

    skills_list = "\n".join(available_skills)
    prompt = prompt_template.format(
        domain_pddl=domain_pddl, 
        observation=observation, 
        instructions=instructions,
        available_skills=skills_list,
        skill_code=skill_code, 
        plan_content=plan_content
    )

    return prompt

