from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick up dice1 from the floor (general object, approach z-axis)
        robot.execute_movement(Object.get("dice1", None), mode=1, axis=2)
        # Step 2: Move to drawer-area (execute_go)
        robot.execute_movement(mode=7)
        # Step 3: Pick up handle_bottom from the floor (handle, approach x-axis)
        robot.execute_movement(Object.get("drawer_bottom_handle", None), mode=1, axis=0)
        # Step 4: Pull drawer_bottom using handle_bottom (pull with x-axis)
        robot.execute_movement(Object.get("drawer_bottom_handle", None), mode=4, distance=0.10)
        # Step 5: Place dice1 into drawer_bottom at drawer-area (place along z-axis)
        robot.execute_movement(Object.get("drawer_bottom_place_left", None), mode=2, axis=2)
        # Step 6: Push drawer_bottom closed at drawer-area
        robot.execute_movement(Object.get("drawer_bottom_place_left", None), mode=3, distance=0.10)
        # Step 7: Move back to ready-pose (execute_go)
        robot.execute_movement(mode=7)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()