from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Pick dice1 from floor (grasp along z-axis, axis=2)
    try:
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=1, axis=2)
    except Exception as e:
        print(f"Error in step 1 (execute_pick dice1): {e}")

    # Step 2: Pick handle_bottom from floor (grasp along x-axis, axis=0)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in step 2 (execute_pick handle_bottom): {e}")

    # Step 3: Pull drawer_bottom using handle_bottom (pull at drawer-area)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in step 3 (execute_pull drawer_bottom): {e}")

    # Step 4: Place dice1 in drawer_bottom at drawer-area (place along z-axis, axis=2)
    try:
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in step 4 (execute_place dice1): {e}")

    # Step 5: Push drawer_bottom at drawer-area (push along x-axis, axis=0)
    try:
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=3, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in step 5 (execute_push drawer_bottom): {e}")


def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()