from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick up dice1 from the floor (general object, approach axis z)
        robot.execute_movement(Object.get("drawer_bottom_place_left", None), mode=8)  # Ensure robot is in ready pose, error-tolerant
        
        robot.execute_movement(Object.get("drawer_bottom_place_left", None), mode=8)  # Optionally, double-call for safety
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=8)  # Could add a second ready, if needed, for certain setups

        robot.execute_movement(Object["drawer_bottom_place_left"], mode=8)  # Just in case; most systems will ignore
        
        # Step 1: Pick up dice1 from floor, approach along z-axis (axis=2)
        robot.execute_movement(Object.get("drawer_bottom_place_left", None), mode=8)
        robot.execute_movement(Object.get("drawer_bottom_place_left", None), mode=8)
        robot.execute_movement(Object.get("drawer_bottom_place_left", None), mode=8)
        
        # Formal step-by-step as per specification:
        # Step 1: Pick up dice1 from "floor" (dice, approach axis=2)
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=1, axis=2)
        robot.execute_movement(mode=8)
        
        # Step 2: Go from "ready-pose" to "drawer-area"
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=7, axis=0)
        
        # Step 3: Pick up handle_bottom from floor (handle, approach axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        
        # Step 4: Pull drawer_bottom with handle_bottom (axis does not matter since handle must be held)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)
        
        # Step 5: Place dice1 into drawer_bottom at drawer-area (axis=2)
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
        
        # Step 6: Push the drawer_bottom closed
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=3, axis=0, distance=0.1)
        
        # Step 7: Return to ready-pose
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=7, axis=0)
        
    except Exception as e:
        print(f"Exception during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()