from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():

    robot = RobotController()

    try:
        # Step 1: Move from ready-pose to handle location (drawer_bottom_handle)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=7)
        
        # Step 2: Pick the handle (drawer_bottom_handle), approach from x-axis (axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        
        # Step 3: Pull the bottom drawer using the handle, approach from x-axis (axis=0), distance=0.1
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
        
        # Step 4: Move from handle location to dice location (for this plan, use yellow_dice as dice1)
        robot.execute_movement(Object["yellow_dice"], mode=7)
        
        # Step 5: Pick up dice1 (yellow_dice), approach from z-axis (axis=2)
        robot.execute_movement(Object["yellow_dice"], mode=1, axis=2)
        
        # Step 6: Move from dice location to drawer_bottom_place_left 
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=7)
        
        # Step 7: Place dice1 (yellow_dice) into the opened bottom drawer (use left placement), approach from z-axis
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
        
        # Step 8: Return to the ready-pose
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"An error occurred during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
