from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick the handle_bottom (approach axis = 0 for handles)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 2: Pull open the drawer_bottom with handle_bottom (distance = 0.1)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)

        # Step 3: Pick dice1 from floor (approach axis = 2 for general object/dice)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Optional: Go to ready-pose if your environment/skill requires resetting pose (otherwise skip)
        robot.execute_movement(mode=8)

        # Step 4: Place dice1 into drawer_bottom (approach axis = 2)
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
        robot.execute_movement(mode=8)  # Return to ready-pose after place

    except Exception as e:
        print(f"Exception occurred during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()