from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Pick dice1 (approach along z-axis for object pick).
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick dice1, floor
    except Exception as e:
        print(f"Error in picking dice1: {e}")

    # Step 2: Pick handle_bottom (approach along x-axis for handle pick/pull).
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)  # execute_pick handle_bottom, floor
    except Exception as e:
        print(f"Error in picking handle_bottom: {e}")

    # Step 3: Pull drawer_bottom using handle_bottom (approach along x-axis).
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)  # execute_pull drawer_bottom, handle_bottom, floor
    except Exception as e:
        print(f"Error in pulling drawer_bottom: {e}")

    # Step 4: Pick dice1 again (ensure held, approach along z-axis).
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick dice1, floor
    except Exception as e:
        print(f"Error in re-picking dice1: {e}")

    # Step 5: Place dice1 in bottom drawer (approach along z-axis for place).
    try:
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)  # execute_place dice1, drawer_bottom, floor
    except Exception as e:
        print(f"Error in placing dice1: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()