from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: execute_pick dice1 from floor (axis=2 for general objects)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick (dice1): {e}")

    # Step 2: execute_pick handle_bottom from floor (axis=0 for handle)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick (handle_bottom): {e}")

    # Step 3: execute_pull drawer_bottom using handle_bottom at floor (axis=0)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during execute_pull (drawer_bottom): {e}")

    # Step 4: execute_place dice1 into drawer_bottom at floor (axis=2)
    try:
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place (dice1 into drawer_bottom): {e}")

    # Step 5: execute_push drawer_bottom at floor (axis=0)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=3, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during execute_push (drawer_bottom): {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()