from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick up dice1 from the floor (approach along z-axis, axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 2: Pick up the handle for the bottom drawer (handle_bottom, approach along x-axis, axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        # Step 3: Pull open the bottom drawer (at drawer-area)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
        # Step 4: Place dice1 into the bottom drawer (drawer-area, approach along z-axis)
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
        # Step 5: Push the bottom drawer closed (drawer-area)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=3, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()