from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick handle_bottom (drawer handle for bottom drawer)
        # Approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 2: Pull out drawer_bottom using its handle
        # Specify a suitable distance to pull (e.g., 0.1 meters)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

        # Step 3: Pick dice1 from the workspace (floor)
        # Approach along z-axis (axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Move to ready pose before placing (required if skill stack expects this)
        robot.execute_movement(mode=8)

        # Step 4: Place dice1 into the bottom drawer (pick a left/right place location)
        # We'll use left position for deterministic behavior
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)

        # Move to ready pose after placing (for safe gripper transitions)
        robot.execute_movement(mode=8)

        # Step 5: Push drawer_bottom closed (push from the handle location)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=3, axis=0, distance=0.1)

    except Exception as e:
        print(f"An error occurred during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()