from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Pick dice1 from the floor (approach along z-axis)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        robot.execute_movement(mode=8)  # go_to_ready_pose after pick
    except Exception as e:
        print(f"[Error] execute_pick dice1: {e}")

    # Step 2: Pick handle_bottom from the floor (approach along x-axis)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        # No ready pose needed
    except Exception as e:
        print(f"[Error] execute_pick handle_bottom: {e}")

    # Step 3: Pull drawer_bottom using handle_bottom at drawer-area (approach along x-axis)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
        # This "pull" action opens the drawer
    except Exception as e:
        print(f"[Error] execute_pull drawer_bottom: {e}")

    # Step 4: Place dice1 into drawer_bottom at drawer-area (approach along z-axis)
    try:
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
        robot.execute_movement(mode=8)  # go_to_ready_pose after place
    except Exception as e:
        print(f"[Error] execute_place dice1: {e}")

    # Step 5: Push drawer_bottom to close it (approach along x-axis)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=3, axis=0, distance=0.1)
    except Exception as e:
        print(f"[Error] execute_push drawer_bottom: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()