from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick dice1 from floor (approach along z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick

        # Step 2: Pick handle_bottom from floor (approach along x-axis)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)  # execute_pick

        # Step 3: Pull drawer_bottom using handle_bottom at drawer-area (pull along x-axis, typically axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)

        # Step 4: Place dice1 into drawer_bottom at drawer-area (approach along z-axis)
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)

    except Exception as e:
        print(f"[ERROR] Task execution failed: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()