from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick on "dice1" from "floor" (approach along z-axis: axis=2)
        robot.primitive_skill.execute_pick(object_name="dice1", location_name="floor", gripper_force=80, axis=2)
        robot.primitive_skill.go_to_ready_pose()

        # Step 2: execute_pick on "handle_bottom" from "floor" (approach along x-axis: axis=0)
        robot.primitive_skill.execute_pick(object_name="handle_bottom", location_name="floor", gripper_force=80, axis=0)

        # Step 3: execute_pull on "drawer_bottom" using "handle_bottom" in "drawer-area" (approach along x-axis: axis=0)
        robot.primitive_skill.execute_pull(drawer_name="drawer_bottom", handle_name="handle_bottom", location_name="drawer-area", gripper_force=80, axis=0, distance=0.1)

        # Step 4: execute_place "dice1" into "drawer_bottom" in "drawer-area" (approach along z-axis: axis=2)
        robot.primitive_skill.execute_place(object_name="dice1", drawer_name="drawer_bottom", location_name="drawer-area", axis=2)
        robot.primitive_skill.go_to_ready_pose()

        # Step 5: execute_push "drawer_bottom" in "drawer-area" (approach along x-axis: axis=0)
        robot.primitive_skill.execute_push(drawer_name="drawer_bottom", location_name="drawer-area", gripper_force=80, axis=0, distance=0.1)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()