from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick up the drawer handle (execute_pick_handle)
        # In skill mapping, execute_pick (mode=1), axis=0 for handle
        handle_key = "drawer_top_handle"
        if handle_key not in Object:
            raise KeyError("Missing 'drawer_top_handle' in Object_list.")
        handle_pose = Object[handle_key]
        robot.execute_movement(handle_pose, mode=1, axis=0)

        # Step 2: Pull open the drawer using the handle (execute_pull)
        # execute_pull (mode=4), axis=0, distance=0.1
        drawer_key = "drawer_top_handle"  # The handle pose is used for pulling
        robot.execute_movement(handle_pose, mode=4, axis=0, distance=0.1)

        # Step 3: Pick up the die (execute_pick_object)
        # execute_pick (mode=1), axis=2 for object
        die_key = "dice1"
        if die_key not in Object:
            raise KeyError("Missing 'dice1' in Object_list.")
        die_pose = Object[die_key]
        robot.execute_movement(die_pose, mode=1, axis=2)

        # Step 4: Return to ready-pose (execute_go_ready)
        # execute_go_ready (mode=8)
        robot.execute_movement(mode=8)

        # Step 5: Place the die into the drawer (execute_place_object)
        # execute_place (mode=2), axis=2
        # Use a drawer place pose; prefer "drawer_top_place_left" if available, else "drawer_top_place_right"
        place_key = "drawer_top_place_left" if "drawer_top_place_left" in Object else "drawer_top_place_right"
        if place_key not in Object:
            raise KeyError("Missing 'drawer_top_place_left' or 'drawer_top_place_right' in Object_list.")
        place_pose = Object[place_key]
        robot.execute_movement(place_pose, mode=2, axis=2)

        # Step 6: Return to ready-pose (execute_go_ready)
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()