from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Move from ready-pose to floor
        robot.execute_movement(Object.get("floor", None), mode=7)  # execute_go

        # Step 2: Pick up dice1 from floor (approach along z-axis)
        robot.execute_movement(Object.get("dice1", None), mode=1, axis=2)  # execute_pick

        # Step 3: (Redundant move from floor to floor, can be a no-op or skipped)
        robot.execute_movement(Object.get("floor", None), mode=7)  # execute_go

        # Step 4: Pick up handle_bottom from floor (approach along x-axis)
        robot.execute_movement(Object.get("drawer_bottom_handle", None), mode=1, axis=0)  # execute_pick

        # Step 5: Pull open drawer_bottom using handle_bottom (approach along x-axis)
        robot.execute_movement(Object.get("drawer_bottom_handle", None), mode=4, axis=0, distance=0.1)  # execute_pull

        # Step 6: Place dice1 into drawer_bottom (approach along z-axis)
        robot.execute_movement(Object.get("drawer_bottom_place_left", None), mode=2, axis=2)  # execute_place

        # Step 7: Push drawer_bottom closed (approach along x-axis)
        robot.execute_movement(Object.get("drawer_bottom_place_left", None), mode=3, axis=0, distance=0.1)  # execute_push

        # Step 8: Move from floor to ready-pose
        robot.execute_movement(Object.get("ready-pose", None), mode=7)  # execute_go

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()