from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick up the top drawer handle (handle pick: axis=0 for x-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        # Step 2: Pull open the top drawer using the handle (pull: axis=0, distance=0.1)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
        # Step 3: Pick up dice1 (object pick: axis=2 for z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 4: Return to ready-pose (go to ready-pose)
        robot.execute_movement(mode=8)
        # Step 5: Place dice1 into the open top drawer (place: axis=2 for z-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Step 6: Return to ready-pose
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()