from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick the drawer handle (approach along x-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        # Step 2: Pull the drawer open using the handle (approach along x-axis, distance=0.1)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
        # Step 3: Pick up the die (dice1) (approach along z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 4: Move to ready pose (required after pick/place)
        robot.execute_movement(mode=8)
        # Step 5: Place the die into the drawer (use left place pose, approach along z-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Step 6: Move to ready pose again
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()