from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick dice1 from floor (approach along z-axis: axis=2)
        robot.primitive_skill.execute_pick(object_name="dice1", location_name="floor", axis=2)

        # Step 2: execute_pick handle_bottom from floor (approach along x-axis: axis=0)
        robot.primitive_skill.execute_pick(object_name="handle_bottom", location_name="floor", axis=0)

        # Step 3: execute_pull drawer_bottom using handle_bottom at drawer-area (approach along x-axis: axis=0)
        robot.primitive_skill.execute_pull(drawer_name="drawer_bottom", handle_name="handle_bottom", location_name="drawer-area", axis=0, distance=0.1)

        # Step 4: execute_pick dice1 from floor again (approach along z-axis: axis=2)
        robot.primitive_skill.execute_pick(object_name="dice1", location_name="floor", axis=2)

        # Step 5: execute_place dice1 into drawer_bottom at drawer-area (approach along z-axis: axis=2)
        robot.primitive_skill.execute_place(object_name="dice1", drawer_name="drawer_bottom", location_name="drawer-area", axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()