from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick up the drawer handle (assume "drawer_top_handle" is the handle for "drawer_top")
        # Approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        # Step 2: Pull open the drawer using the handle (axis=0, distance=0.1 for a full pull)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
        # Step 3: Pick up the dice (assume "dice1" is the dice to store), approach along z-axis (axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 4: Move to ready-pose before placing
        robot.execute_movement(mode=8)
        # Step 5: Place the dice into the drawer (assume "drawer_top_place_left" is the place pose), approach along z-axis (axis=2)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Step 6: Move to ready-pose after placing
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()