from Object_list import Object
from skill_mapping import RobotController


def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for: “Place one dice into a drawer.”
    The sequence strictly follows the specification steps and only
    utilises the predefined primitive skills exposed through
    RobotController.execute_movement().
    """
    robot = RobotController()

    try:
        # ------------------------------------------------------------
        # 1) execute_go  (ready-pose -> drawer-area)
        #    -> use bottom-drawer handle pose as the target inside the
        #       drawer area.
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_handle"], mode=7)

        # ------------------------------------------------------------
        # 2) execute_pick  (handle_bottom)
        #    -> approach along x-axis (axis = 0)
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_handle"],
                               mode=1, axis=0)

        # ------------------------------------------------------------
        # 3) execute_pull  (drawer_bottom, handle_bottom)
        #    -> pull the drawer open
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_handle"],
                               mode=4, distance=0.10)

        # ------------------------------------------------------------
        # 4) execute_pick  (dice1)
        #    -> pick the dice from the floor, approach from z-axis
        # ------------------------------------------------------------
        robot.execute_movement(Object["dice1"],
                               mode=1, axis=2)

        # ------------------------------------------------------------
        # 5) go_to_ready_pose
        # ------------------------------------------------------------
        robot.execute_movement(mode=8)

        # ------------------------------------------------------------
        # 6) execute_place  (dice1, drawer_bottom)
        #    -> place the dice into the opened bottom drawer
        #       (use left placement pose)
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_place_left"],
                               mode=2, axis=2)

        # ------------------------------------------------------------
        # 7) go_to_ready_pose
        # ------------------------------------------------------------
        robot.execute_movement(mode=8)

        # ------------------------------------------------------------
        # 8) execute_push  (drawer_bottom)
        #    -> close the drawer by pushing its handle
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_handle"],
                               mode=3, axis=0, distance=0.10)

    except KeyError as exc:
        print(f"[ERROR] Object alias not found: {exc}")
    except Exception as exc:
        print(f"[ERROR] Unexpected issue during task execution: {exc}")


def main():
    Long_horizon_task2_oracle_seq()


if __name__ == "__main__":
    main()