from Object_list import Object
from skill_mapping import RobotController


def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for:
        “Place one dice into a drawer.”

    Plan (derived from specification):
        1. Pick the bottom-drawer handle (approach along x-axis).
        2. Pull the bottom drawer open.
        3. Pick the dice that lies on the floor (approach along z-axis).
        4. Return to the ready-pose (required before any place action).
        5. Place the dice inside the opened bottom drawer.
        6. Return to the ready-pose (task completed).
    """

    robot = RobotController()

    try:
        # 1) Pick the drawer handle (x-axis approach)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # 2) Pull the drawer open (keep x-axis, pull distance 0.10 m)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

        # 3) Pick the first dice from the floor (z-axis approach)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # 4) Go to ready-pose – mandatory before place when need-ready flag is set
        robot.execute_movement(mode=8)

        # 5) Place the dice into the opened bottom drawer (z-axis approach)
        #    We use the predefined pose inside the drawer (left side).
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)

        # 6) Return to ready-pose – task finished
        robot.execute_movement(mode=8)

    except KeyError as e:
        print(f"[ERROR] Unknown object key: {e}")
    except Exception as e:
        print(f"[ERROR] Unexpected exception during task execution: {e}")


def main():
    Long_horizon_task2_oracle_seq()


if __name__ == "__main__":
    main()
