from Object_list import Object
from skill_mapping import RobotController

def place_one_dice_in_drawer():
    """
    Place one dice into a drawer.
    Assumes the robot starts at any position, the dice is on the floor, and the drawer is open and not full.
    """
    robot = RobotController()
    # Move to the dice location (floor)
    robot.execute_movement(Object.get("floor", None), mode=7)
    # Pick up dice1 (assuming dice1 is the one to use)
    robot.execute_movement(Object.get("dice1", None), mode=1, axis=2)
    # Move to the drawer area
    robot.execute_movement(Object.get("drawer-area", None), mode=7)
    # Place dice1 into drawer_bottom (assuming drawer_bottom is the target and is open)
    robot.execute_movement(Object.get("drawer_bottom", None), mode=2, axis=2)

def main():
    place_one_dice_in_drawer()

if __name__ == "__main__":
    main()