"""Module to store a dice inside the drawer using predefined robot skills."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Store a dice inside the drawer using the robot's primitive skills.
    """
    robot = RobotController()

    # Move to handle_bottom location
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=7)
    except Exception as error:
        print(f"Error in step 1 (go to handle_bottom): {error}")

    # Pick handle_bottom (approach along x-axis)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as error:
        print(f"Error in step 2 (pick handle_bottom): {error}")

    # Pull drawer_bottom using handle_bottom (approach along x-axis)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as error:
        print(f"Error in step 3 (pull drawer_bottom): {error}")

    # Move to dice1 location
    try:
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=7)
    except Exception as error:
        print(f"Error in step 4 (go to dice1): {error}")

    # Pick dice1 (approach along z-axis)
    try:
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=1, axis=2)
    except Exception as error:
        print(f"Error in step 5 (pick dice1): {error}")

    # Move to drawer_bottom location
    try:
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=7)
    except Exception as error:
        print(f"Error in step 6 (go to drawer_bottom): {error}")

    # Place dice1 in drawer_bottom (approach along z-axis)
    try:
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
    except Exception as error:
        print(f"Error in step 7 (place dice1): {error}")

    # Move to handle_bottom location
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=7)
    except Exception as error:
        print(f"Error in step 8 (go to handle_bottom): {error}")

    # Push drawer_bottom closed (approach along x-axis)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=3, axis=0, distance=0.1)
    except Exception as error:
        print(f"Error in step 9 (push drawer_bottom): {error}")

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()