"""Module to drop one dice into any open drawer."""

from Object_list import Object
from skill_mapping import RobotController

def drop_one_dice_into_open_drawer():
    """
    Drops one dice into any open drawer.
    Assumes at least one dice is on the floor and at least one drawer is open and not full.
    """
    robot = RobotController()

    # Find any dice on the floor
    dice_candidates = [name for name in ["dice1", "dice2"] if Object[name].is_on_floor()]
    if not dice_candidates:
        print("No dice available on the floor.")
        return

    # Find any open drawer that is not full
    drawer_candidates = [name for name in ["drawer_bottom", "drawer_middle", "drawer_top"]
                        if Object[name].is_drawer_open() and not Object[name].is_drawer_full()]
    if not drawer_candidates:
        print("No open drawer available.")
        return

    dice = dice_candidates[0]
    drawer = drawer_candidates[0]

    # Pick up the dice (assume approach along z-axis)
    robot.execute_movement(Object[dice], mode=1, axis=2)
    robot.execute_movement(mode=8)

    # Place the dice into the open drawer (assume approach along z-axis)
    place_location = Object[f"{drawer}_place_left"]
    robot.execute_movement(place_location, mode=2, axis=2)
    robot.execute_movement(mode=8)

def main():
    drop_one_dice_into_open_drawer()

if __name__ == "__main__":
    main()