"""Module to execute the task: Put a single dice into the drawer."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to put a single dice into a drawer."""
    robot = RobotController()

    try:
        # Move from ready-pose to floor
        robot.execute_movement(Object.get("floor", None), mode=7)

        # Pick dice1 from floor (approach along z-axis)
        robot.execute_movement(Object.get("dice1", None), mode=1, axis=2)

        # Move to floor (noop, for completeness)
        robot.execute_movement(Object.get("floor", None), mode=7)

        # Pick handle_bottom from floor (approach along x-axis)
        robot.execute_movement(Object.get("handle_bottom", None), mode=1, axis=0)

        # Pull drawer_bottom using handle_bottom at floor
        robot.execute_movement(Object.get("drawer_bottom_handle", None), mode=4, axis=0, distance=0.1)

        # Move from floor to drawer-area
        robot.execute_movement(Object.get("drawer-area", None), mode=7)

        # Place dice1 into drawer_bottom at drawer-area (approach along z-axis)
        robot.execute_movement(Object.get("drawer_bottom_place_left", None), mode=2, axis=2)

        # Push drawer_bottom at drawer-area
        robot.execute_movement(Object.get("drawer_bottom_place_left", None), mode=3, axis=0, distance=0.1)

        # Move from drawer-area to ready-pose
        robot.execute_movement(Object.get("ready-pose", None), mode=7)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point for the task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()