"""Module to store a dice inside the drawer using robot actions."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to store a dice inside the drawer."""
    robot = RobotController()

    try:
        # Step 1: Move from ready-pose to floor
        robot.execute_movement(Object.get("floor", None), mode=7)
    except Exception as error:
        print(f"Error in Step 1 (execute_go ready-pose->floor): {error}")

    try:
        # Step 2: Pick dice1 from floor (axis=2 for general object)
        robot.execute_movement(Object.get("dice1", None), mode=1, axis=2)
    except Exception as error:
        print(f"Error in Step 2 (execute_pick dice1): {error}")

    try:
        # Step 3: Move from floor to floor (noop, but included for plan completeness)
        robot.execute_movement(Object.get("floor", None), mode=7)
    except Exception as error:
        print(f"Error in Step 3 (execute_go floor->floor): {error}")

    try:
        # Step 4: Pick handle_bottom from floor (axis=0 for handle)
        robot.execute_movement(Object.get("handle_bottom", None), mode=1, axis=0)
    except Exception as error:
        print(f"Error in Step 4 (execute_pick handle_bottom): {error}")

    try:
        # Step 5: Pull drawer_bottom using handle_bottom at floor
        robot.execute_movement(Object.get("handle_bottom", None), mode=4, axis=0, distance=0.1)
    except Exception as error:
        print(f"Error in Step 5 (execute_pull drawer_bottom): {error}")

    try:
        # Step 6: Move from floor to drawer-area
        robot.execute_movement(Object.get("drawer-area", None), mode=7)
    except Exception as error:
        print(f"Error in Step 6 (execute_go floor->drawer-area): {error}")

    try:
        # Step 7: Place dice1 into drawer_bottom at drawer-area (axis=2 for general object)
        robot.execute_movement(Object.get("drawer_bottom_place_left", None), mode=2, axis=2)
    except Exception as error:
        print(f"Error in Step 7 (execute_place dice1): {error}")

    try:
        # Step 8: Move from drawer-area to floor
        robot.execute_movement(Object.get("floor", None), mode=7)
    except Exception as error:
        print(f"Error in Step 8 (execute_go drawer-area->floor): {error}")

    try:
        # Step 9: Push drawer_bottom at floor (axis=0 for push, default)
        robot.execute_movement(Object.get("drawer_bottom_handle", None), mode=3, axis=0, distance=0.1)
    except Exception as error:
        print(f"Error in Step 9 (execute_push drawer_bottom): {error}")

    try:
        # Step 10: Move from floor to ready-pose
        robot.execute_movement(Object.get("ready-pose", None), mode=7)
    except Exception as error:
        print(f"Error in Step 10 (execute_go floor->ready-pose): {error}")

def main():
    """Main function to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()