"""Module to put a single dice into a drawer using robot primitive skills."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to put a single dice into a drawer."""
    robot = RobotController()

    # Step 1: Move from ready-pose to handle_bottom_location
    robot.execute_movement(Object["drawer_bottom_handle"], mode=7)

    # Step 2: Pick handle_bottom (approach along x-axis)
    robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

    # Step 3: Pull drawer_bottom using handle_bottom
    robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)

    # Step 4: Move from handle_bottom_location to dice1_location
    robot.execute_movement(Object["dice1"], mode=7)

    # Step 5: Pick dice1 (approach along z-axis)
    robot.execute_movement(Object["dice1"], mode=1, axis=2)

    # Step 6: Move from dice1_location to drawer_bottom_place_location
    robot.execute_movement(Object["drawer_bottom_place_left"], mode=7)

    # Step 7: Place dice1 into drawer_bottom (approach along z-axis)
    robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)

def main():
    """Main entry point to execute the dice-in-drawer task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()