"""Module to put a single dice into the drawer using RobotController."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to put a single dice into the drawer."""
    robot = RobotController()

    # Move to the location of dice1 and pick it up (approach along z-axis: axis=2)
    robot.execute_movement(Object["dice1"], mode=1, axis=2)
    robot.execute_movement(mode=8)  # Go to ready pose after pick

    # Move to the drawer area and place dice1 into drawer_bottom (approach along z-axis: axis=2)
    robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
    robot.execute_movement(mode=8)  # Go to ready pose after place

def main():
    """Main function to execute the task sequence."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()