from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence: Put a single dice into the drawer using primitive skills and the oracle plan.
    Specification:
      1. Pick the dice
      2. Move to drawer handle
      3. Pick the handle
      4. Pull the drawer open
      5. Place the dice into the drawer
      6. Push the drawer closed
    The axis parameter controls the robot approach direction (0: x-axis for handles, 2: z-axis for general objects/dice).
    """

    robot = RobotController()

    try:
        # Step 1: Pick up the dice ("dice1" is the designated dice, approach along z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick dice1: {e}")

    try:
        # Step 2: Move to drawer handle (use "drawer_bottom_handle" as the drawer handle location)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=7)
    except Exception as e:
        print(f"Error during execute_go to drawer_bottom_handle: {e}")

    try:
        # Step 3: Pick up the handle (approach along x-axis)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick drawer_bottom_handle: {e}")

    try:
        # Step 4: Pull the drawer open (using handle, approach along x-axis, with distance=0.1)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during execute_pull on drawer_bottom_handle: {e}")

    try:
        # Step 5: Place dice into drawer (use "drawer_bottom_place_left" as place location, approach along z-axis)
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place dice1: {e}")

    try:
        # Step 6: Push the drawer closed (using handle, approach along x-axis, with distance=0.1)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=3, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during execute_push on drawer_bottom_handle: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()