from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Move robot from ready-pose to floor (Frozen Code, do not change)
    robot.execute_movement(Object["floor"], mode=7)

    # Step 1: Pick any dice from the floor.
    # We'll pick 'dice1'. Approach along z-axis (axis=2) for dice.
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error: Failed to pick dice1: {e}")

    # Step 2: Move to ready pose before placing (required by skill logic)
    try:
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error: Failed to return to ready pose: {e}")

    # Step 3: Place the dice into an open drawer.
    # We'll use 'drawer_top_place_left' (assumed to be an open drawer pose). Approach along z-axis (axis=2).
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error: Failed to place dice1 into drawer_top_place_left: {e}")

    # (Optional) Return to ready pose at end for consistency/cleanliness
    try:
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error: Failed to return to ready pose after placing: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()