from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for: Place one dice into a drawer.
    This function strictly follows the required oracle plan and specification steps,
    using only the specified skills and the object list provided.
    The axis parameter is set appropriately:
      - axis=2 for dice/object pick/place (z-axis approach)
      - axis=0 for drawer handle pick/pull (x-axis approach)
    Only 'dice1' is used as the dice instance, and the top drawer/handle is chosen.
    """

    robot = RobotController()

    try:
        # Step 1: Pick up the dice (e.g., dice1) from its pose, approach along z-axis (axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Step 2: Pick up the drawer handle (top drawer), approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Step 3: Pull open the drawer using the handle, pull along x-axis (axis=0), distance=0.1
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

        # Step 4: Place dice into the drawer at left place spot, approach along z-axis (axis=2)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Optionally, return to ready pose at the end
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
