from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Move from ready-pose to floor (e.g. starting navigation)
    robot.execute_movement(pose0=Object["ready-pose"], pose1=Object["floor"], mode=7)
    # Step 2: Pick up dice1 from floor (axis=2 for object)
    robot.execute_movement(pose0=Object["dice1"], pose1=Object["floor"], mode=1, axis=2)
    # Step 3: Move from floor to drawer area
    robot.execute_movement(pose0=Object["floor"], pose1=Object["drawer-area"], mode=7)
    # Step 4: Pick up handle_bottom from drawer-area (axis=0 for handle)
    robot.execute_movement(pose0=Object["handle_bottom"], pose1=Object["drawer-area"], mode=1, axis=0)
    # Step 5: Pull the drawer_bottom using handle_bottom at drawer-area
    robot.execute_movement(pose0=Object["drawer_bottom"], pose1=(Object["handle_bottom"], Object["drawer-area"]), mode=4, distance=0.1)
    # Step 6: Move from drawer-area (handle) to drawer opening position
    robot.execute_movement(pose0=Object["drawer-area"], pose1=Object["drawer_bottom_place_left"], mode=7)
    # Step 7: Place dice1 into drawer_bottom at drawer opening (axis=2 for object)
    robot.execute_movement(pose0=Object["dice1"], pose1=(Object["drawer_bottom"], Object["drawer_bottom_place_left"]), mode=2, axis=2)
    # Step 8: Move from drawer opening position back to handle area
    robot.execute_movement(pose0=Object["drawer_bottom_place_left"], pose1=Object["drawer-area"], mode=7)
    # Step 9: Push the drawer_bottom closed at drawer-area
    robot.execute_movement(pose0=Object["drawer_bottom"], pose1=Object["drawer-area"], mode=3, distance=0.15)

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()