from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Pick the dice1 from floor, approach along z-axis (axis=2)
    robot.execute_movement(Object["dice1"], mode=1, axis=2)
    # Step 2: Pick the bottom drawer handle, approach along x-axis (axis=0)
    robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    # Step 3: Pull the bottom drawer open using the handle, along x-axis (axis=0), distance=0.1m
    robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

    # Step 4: Place the dice into the left place of the bottom drawer, approach along z-axis (axis=2)
    try:
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in placing dice1 into drawer: {e}")

    # Step 5: Push the bottom drawer closed, push along x-axis (axis=0), distance=0.15m
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=3, axis=0, distance=0.15)
    except Exception as e:
        print(f"Error in pushing drawer closed: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()