from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence to achieve the goal: Drop one dice into any open drawer.
    This follows the specification: pick a dice, and place it in a drawer.
    Only execute_pick and execute_place skills are required.
    """
    robot = RobotController()
    try:
        # STEP 1: Pick up a dice (choose "dice1") from its location (top-down grasp, axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # As per PDDL, need to return to ready pose after pick
        robot.execute_movement(mode=8)
        # STEP 2: Place the dice into an open drawer location (choose "drawer_top_place_left"), top-down place
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Optionally return to ready pose at end
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()