from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # 1. Move from ready-pose to floor
        robot.execute_movement(Object.get("ready-pose", None), Object.get("floor", None), mode=6)  # Dummy rotate if needed to reach target
        robot.execute_movement(Object.get("ready-pose", None), Object.get("floor", None), mode=7)

        # 2. Pick dice1 from floor (along z-axis: axis=2)
        robot.execute_movement(Object.get("dice1", None), mode=1, axis=2)

        # 3. Pick handle_top from floor (approach along x-axis: axis=0)
        robot.execute_movement(Object.get("handle_top", None), mode=1, axis=0)

        # 4. Move from floor to drawer-area
        robot.execute_movement(Object.get("floor", None), Object.get("drawer-area", None), mode=6)  # Dummy rotate if needed
        robot.execute_movement(Object.get("floor", None), Object.get("drawer-area", None), mode=7)

        # 5. Pull drawer_top open using handle_top (axis=0, typical for drawer handles)
        robot.execute_movement(Object.get("drawer_top_handle", None), mode=4, axis=0)  # Use the handle

        # 6. Place handle_top (release handle, along x-axis or z-axis; z is safer if unclear)
        robot.execute_movement(Object.get("handle_top", None), mode=2, axis=2)

        # 7. Place dice1 into drawer_top at drawer-area (axis=2: standard for placing objects down into a drawer)
        # We'll use the drawer_top_place_left location as a proxy for "into drawer_top"
        robot.execute_movement(Object.get("drawer_top_place_left", None), mode=2, axis=2)

        # 8. Push drawer_top closed (axis=0, pushing along x-axis toward closed position)
        robot.execute_movement(Object.get("drawer_top_handle", None), mode=3, axis=0)

        # 9. Move from drawer-area to ready-pose
        robot.execute_movement(Object.get("drawer-area", None), Object.get("ready-pose", None), mode=6)  # Dummy rotate if needed
        robot.execute_movement(Object.get("drawer-area", None), Object.get("ready-pose", None), mode=7)

    except Exception as e:
        print(f"Error during long horizon task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
