from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Move from ready-pose to floor (execute_go)
        # Assuming we don't need explicit target poses since movement mode 7 is go, and we can use positions of handle_top as goal
        # But as we have no explicit mapping, we use the handle location as the reference pose
        robot.execute_movement(Object["drawer_top_handle"], mode=7)  # mode=7: execute_go

        # Step 2: Pick the handle_top from floor (execute_pick)
        # Approach handle along x-axis (axis=0)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)  # mode=1: execute_pick

        # Step 3: Pull drawer open using handle (execute_pull)
        # For pulling, use drawer_top_handle position, mode=4, axis=0 for x-axis, distance ~0.1 by convention
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)  # mode=4: execute_pull

        # Step 4: Pick the dice from floor (execute_pick)
        # Approach dice along z-axis (axis=2)
        robot.execute_movement(Object["yellow_dice"], mode=1, axis=2)  # mode=1: execute_pick

        # Step 5: Place dice into drawer (execute_place)
        # Place dice into left place in the top drawer (arbitrary, as spec does not specify L/R)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)  # mode=2: execute_place

    except Exception as e:
        print(f"Error executing oracle sequence: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()