from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Pick up dice1 from the floor
    try:
        if "dice1" in Object:
            robot.execute_movement(Object["dice1"], mode=1, axis=2)
        else:
            print("[ERROR] Object 'dice1' not found in Object list.")
            return
    except Exception as e:
        print(f"[ERROR] Exception during picking dice1: {str(e)}")
        return

    # Step 2: Pick up handle_top from the floor (to open the drawer)
    try:
        if "handle_top" in Object:
            robot.execute_movement(Object["handle_top"], mode=1, axis=0)
        else:
            print("[ERROR] Object 'handle_top' not found in Object list.")
            return
    except Exception as e:
        print(f"[ERROR] Exception during picking handle_top: {str(e)}")
        return

    # Step 3: Pull and open the drawer_top using handle_top at drawer-area
    try:
        if "drawer_top_handle" in Object:
            robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
        else:
            print("[ERROR] Object 'drawer_top_handle' not found in Object list.")
            return
    except Exception as e:
        print(f"[ERROR] Exception during pulling drawer_top: {str(e)}")
        return

    # Step 4: Place dice1 into drawer_top at drawer-area
    try:
        if "drawer_top_place_left" in Object:
            robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        else:
            # fallback to generic "drawer_top" if no specific "place" pose
            if "drawer_top" in Object:
                robot.execute_movement(Object["drawer_top"], mode=2, axis=2)
            else:
                print("[ERROR] Placement pose for drawer_top not found in Object list.")
                return
    except Exception as e:
        print(f"[ERROR] Exception during placing dice1: {str(e)}")
        return

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
