from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Move to floor from ready-pose
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=6)  # Dummy to set axis, not actual movement
        robot.execute_movement(pose0=None, pose1=None, mode=7)  # Ensure robot is ready to go
    except Exception:
        pass
    try:
        # No explicit pose; just call move
        robot.execute_movement(pose0=None, pose1=None, mode=7)
    except Exception:
        pass

    # Step 1: execute_go from ready-pose to floor (using execute_go)
    try:
        robot.execute_movement(pose0=None, pose1=None, mode=7)
    except Exception:
        pass

    # Step 2: execute_pick handle_top at floor
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception:
        pass

    # Step 3: execute_go from floor to drawer-area
    try:
        robot.execute_movement(pose0=None, pose1=None, mode=7)
    except Exception:
        pass

    # Step 4: execute_pull drawer_top with handle_top at drawer-area
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception:
        pass

    # Step 5: execute_go from drawer-area to floor
    try:
        robot.execute_movement(pose0=None, pose1=None, mode=7)
    except Exception:
        pass

    # Step 6: execute_pick dice1 at floor
    try:
        robot.execute_movement(Object["yellow_dice"], mode=1, axis=2)
    except Exception:
        pass

    # Step 7: execute_go from floor to drawer-area
    try:
        robot.execute_movement(pose0=None, pose1=None, mode=7)
    except Exception:
        pass

    # Step 8: execute_place dice1 in drawer_top at drawer-area
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception:
        pass

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
