from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    
    try:
        # Step 1: Move from ready-pose to drawer-area
        robot.execute_movement(Object["drawer_top_handle"], mode=7)  # execute_go
        
        # Step 2: Pick the handle_top (=drawer_top_handle) at drawer-area, axis=0 for handle
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)  # execute_pick

        # Step 3: Pull to open the drawer (drawer_top with handle_top at drawer-area)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, distance=0.1)  # execute_pull

        # Step 4: Pick the dice1 at drawer-area, axis=2 (top-down)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick

        # Step 5: Place dice1 in drawer_top at drawer-area, axis=2 (top-down)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)  # execute_place

        # Step 6: Move back to ready-pose
        robot.execute_movement(Object["drawer_top_handle"], mode=7)  # execute_go

    except Exception as e:
        print(f"Error during execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
