from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Move from ready-pose to floor
        # Approaching floor (where dice1 and handle_top are located)
        robot.execute_movement(Object["drawer_top_handle"], mode=7)  # execute_go

        # Step 2: Pick dice1 on floor (approach along z-axis for object pick)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick

        # Step 3: Pick handle_top on floor (approach along x-axis for handle pick)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)  # execute_pick for handle

        # Step 4: Move from floor to drawer-area
        robot.execute_movement(Object["drawer_top_handle"], mode=7)  # execute_go

        # Step 5: Pull to open drawer_top using handle_top at drawer-area (approach along x-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)  # execute_pull

        # Step 6: Place dice1 into drawer_top at drawer-area (approach along z-axis for object place)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)  # execute_place

        # Step 7: Push drawer_top closed at drawer-area (approach along x-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=3, axis=0, distance=0.1)  # execute_push

        # Step 8: Move robot from drawer-area back to ready-pose
        robot.execute_movement(Object["drawer_top_handle"], mode=8)  # go_to_ready_pose or execute_go to ready

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()