from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for task:
    "Store a dice inside the drawer."
    Follows the step-by-step plan provided in the specification.
    """

    robot = RobotController()

    try:
        # Step 1: Pick the handle from the floor (handle_top)
        # Axis 0: x-axis approach for handles
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Step 2: Move from floor to drawer-area
        robot.execute_movement(mode=7)  # execute_go

        # Step 3: Pull open the drawer using the handle
        # Axis 0: x-axis approach for pull
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

        # Step 4: Move from drawer-area to floor
        robot.execute_movement(mode=7)  # execute_go

        # Step 5: Pick up the dice (dice1) from the floor
        # Axis 2: z-axis approach for pick on general object
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Step 6: Move from floor to drawer-area
        robot.execute_movement(mode=7)  # execute_go

        # Step 7: Place the dice inside the drawer
        # Axis 2: z-axis approach for place
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except Exception as e:
        print(f"Exception occurred during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
