# run_skeleton_task.py (Completed for Exploration Phase and Predicate Missing Detection)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation, now with exploration for missing predicates.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase for Predicate Discovery ===
        print("[Exploration] Starting exploration phase to find missing predicates.")
        # Attempt to use available predefined skills to interact and gather missing info

        # Collect all objects and locations from positions if available
        object_names = []
        location_names = []
        for name, pos in positions.items():
            if "drawer" in name or "table" in name or "pose" in name or "room" in name or "loc" in name or "place" in name:
                location_names.append(name)
            else:
                object_names.append(name)

        # Fallback: If location_names is empty, try to infer one (e.g. use 'workspace' or similar names)
        if not location_names and len(positions) > 0:
            # Try to extract one location as fallback
            first_pos_key = list(positions.keys())[0]
            location_names.append(first_pos_key)

        exploration_done = False
        for obj in object_names:
            print(f"[Exploration] Checking object: {obj}")
            for loc in location_names:
                # Try picking the object (to potentially trigger weight-known/durability-known predicates)
                try:
                    print(f"[Exploration] Attempting to pick {obj} at {loc}")
                    # Example: execute_pick or execute_pick_weight if available
                    obs, reward, done = execute_pick(env, task, target=obj, location=loc)
                    if done:
                        print(f"[Exploration] Picked {obj} at {loc}, done: {done}")
                        exploration_done = True
                        break
                except Exception as e:
                    print(f"[Exploration] Pick failed for {obj} at {loc}: {e}")

                # Try pulling the object (to potentially trigger lock-known predicate)
                try:
                    print(f"[Exploration] Attempting to pull {obj} at {loc}")
                    obs, reward, done = execute_pull(env, task, target=obj, location=loc)
                    if done:
                        print(f"[Exploration] Pulled {obj} at {loc}, done: {done}")
                        exploration_done = True
                        break
                except Exception as e:
                    print(f"[Exploration] Pull failed for {obj} at {loc}: {e}")

                # Try pushing if available
                try:
                    print(f"[Exploration] Attempting to push the drawer/location {loc}")
                    obs, reward, done = execute_push(env, task, target=loc)
                    if done:
                        print(f"[Exploration] Drawer/location {loc} pushed, done: {done}")
                        exploration_done = True
                        break
                except Exception as e:
                    print(f"[Exploration] Push failed for drawer/location {loc}: {e}")

            if exploration_done:
                break

        if not exploration_done:
            print("[Exploration] Could not determine missing predicate with the given actions and environment setup.")
        else:
            print("[Exploration] Exploration phase completed successfully.")

        print("===== Exploration Phase Complete =====")

    except Exception as overall_e:
        print(f"[Error] Exception in overall skeleton task: {overall_e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
