# run_skeleton_task.py (Completed for Exploration Phase and Predicate Identification)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation (with exploration for missing predicates).'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase for Predicate Discovery ===
        # Problem context: Feedback indicates (robot-at table1) predicate may be missing or important
        print("[Exploration] Discovering/Validating predicate: (robot-at table1)")

        # Try to find the robot's current location and check if 'table1' exists in positions
        robot_location = None
        table1_location = None

        # Example: positions might be {'robot': (x,y,z), 'table1': (x,y,z), ...}
        # If there's a mapping of named locations (strings)
        for name, pos in positions.items():
            if 'robot' in name.lower():
                robot_location = pos
            if 'table1' in name.lower():
                table1_location = pos

        # If we cannot directly access named locations, prompt for keys and print positions
        if robot_location is None or table1_location is None:
            print("[Exploration] Could not locate 'robot' or 'table1' in object positions. Available keys:", list(positions.keys()))

        # Assume the environment provides a function or info to get discrete locations,
        # otherwise, we simulate a move to 'table1'
        action_success = False
        try:
            if table1_location is not None:
                print(f"[Exploration] Attempting to move robot to 'table1' at position: {table1_location}")
                # Use execute_go(skill) to move robot to 'table1'
                obs, reward, done = execute_go(
                    env,
                    task,
                    from_loc=robot_location,
                    to_loc=table1_location,
                    max_steps=100
                )
                print(f"[Exploration] Robot moved to 'table1': success={done}")
                action_success = done
            else:
                print("[Exploration] 'table1' location unknown. Skipping execute_go action.")
        except Exception as e:
            print("[Exploration] Exception during execute_go:", str(e))

        # After executing, check the state/observation to see if robot-at table1 is now true
        try:
            obs_after = task.get_observation()
            # obs_after processing depends on the environment API;
            # For demonstration, just print or check relevant predicates/states
            print("[Exploration] Observation after moving to table1:", obs_after)
        except Exception as e:
            print("[Exploration] Exception retrieving observation after execute_go:", str(e))

        # Optionally, try another skill or state interrogation if needed (depending on feedback–here feedback is only about robot-at)
        # If the predicate is still missing, you would need to adjust the domain – but in this skeleton, we are only confirming its presence.

        print("[Exploration] Exploration phase complete. (Check above logs for missing predicate evidence.)")

        # === Proceed with Task Plan (Oracle plan, if any) ===
        # At this point, you can proceed with the rest of your planned steps after verifying/identifying predicates
        # Add main task logic here or return if only exploration was required.

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
