from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick up the top drawer handle (approach along x-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        # Step 2: Pull the top drawer open using the handle (approach along x-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
        # Step 3: Pick up the trash from inside the drawer (approach along z-axis)
        robot.execute_movement(Object["trash"], mode=1, axis=2)
        # Step 4: Return to ready-pose
        robot.execute_movement(mode=8)
        # Step 5: Place the trash into the bin (approach along z-axis)
        robot.execute_movement(Object["trash_bin"], mode=2, axis=2)
        # Step 6: Return to ready-pose
        robot.execute_movement(mode=8)
        # Step 7: Pick up one dice (dice1) from the floor (approach along z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 8: Return to ready-pose
        robot.execute_movement(mode=8)
        # Step 9: Place the dice into the drawer (use drawer_top_place_left, approach along z-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Step 10: Return to ready-pose
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()