from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # [Frozen Code Start]
        robot.execute_movement(Object["ready-pose"], Object["floor"], mode=7)
        robot.execute_movement(Object["handle_top"], mode=1, axis=0)
        robot.execute_movement(Object["drawer_top"], Object["handle_top"], mode=4, axis=0, distance=0.1)
        # [Frozen Code End]

        # Pick trash1 from inside drawer_top (approach along z-axis)
        robot.execute_movement(Object["trash"], mode=1, axis=2)

        # Move to ready-pose
        robot.execute_movement(mode=8)

        # Place trash1 into bin (approach along z-axis)
        robot.execute_movement(Object["trash_bin"], mode=2, axis=2)

        # Move to ready-pose
        robot.execute_movement(mode=8)

        # Pick dice1 from floor (approach along z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Move to ready-pose
        robot.execute_movement(mode=8)

        # Place dice1 into drawer_top (approach along z-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Move to ready-pose
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()